//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Karagiannaki comparison
// Objective: 	Generate the figure 2.6/table B.7 statistic that is compared with Karagiannaki's research
//
//==============================================================================

clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge

merge m:1 wave using CPI.dta //CPI data
drop if _merge == 2
drop _merge 

xtset xwaveid wave

drop if hgint == 0 //drop non-responders

************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due to first estates
 
replace hwnwip = hwnwip * 100/CPI //convert to real values
replace hwnwin = hwnwin * 100/CPI
replace bequest = bequest * 100/CPI

gen L8_bequest = bequest + L.bequest + L2.bequest + L3.bequest + L4.bequest + L5.bequest + L6.bequest + L7.bequest + L8.bequest //need 9 waves (8 lags) of inheritances relative to wealth in the final year (see p.403 of Karagiannaki)

drop if L8_bequest == .

egen L8_bequest_HH = total(L8_bequest), by(hhrhid wave) //household level inheritances

gen net_worth = hwnwip - hwnwin - L8_bequest_HH //ex inheritance net worth
gen net_worth_plus_bequest = hwnwip - hwnwin //net worth

************************
*** Tranform data ***
************************

drop if wlrb_j == 0 //wave 2-10 balanced panel weight
drop if wave != 10
collapse (mean) L8_bequest_HH net_worth net_worth_plus_bequest wlrb_j, by(hhrhid)

************************
* Calculate quintiles **
************************

xtile net_worth_quin = net_worth [pweight = wlrb_j], nq(5)

collapse (sum) net_worth net_worth_plus_bequest, by(net_worth_quin)

egen total_net_worth = total(net_worth)
egen total_net_worth_plus_bequest = total(net_worth_plus_bequest)

gen share_net_worth = net_worth/total_net_worth
gen share_net_worth_plus_bequest = net_worth_plus_bequest/total_net_worth_plus_bequest

gen diff = (share_net_worth_plus_bequest - share_net_worth) * 100 //-.36455393 for the fifth quartile - table B.7/figure 2.6
